#!/bin/bash

read -p "Do you want to create a desktop icon? [enter y for yes]: " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]; then
	desktopVar=$(cat $HOME/.config/user-dirs.dirs | grep "XDG_DESKTOP_DIR")
	desktopFolder=$(echo ${desktopVar/XDG_DESKTOP_DIR=/""} | tr -d '"')
	FILE=$(eval echo $desktopFolder/Horizon.desktop)
	echo "Creating: $FILE..."
	echo "[Desktop Entry]" > $FILE
	echo "Name=Horizon" >> $FILE
	echo "Type=Application" >> $FILE
	echo "StartupNotify=true" >> $FILE
	echo "Exec=$PWD/main" >> $FILE
	echo "Path=$PWD/" >> $FILE
	echo "Icon=$PWD/media/icon.png" >> $FILE
	chmod ug+x $FILE
fi

echo 
echo "You can either choose OpenGL ES or OpenGL for rendering. Some embedded devices don't support OpenGL. Therefore OpenGL ES is recommended."
read -p "Do you want to use OpenGL ES? [y for OpenGL ES, other keys for OpenGL]: " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]; then
	echo "driver = gles" > desktopConfig.ini
else
	echo "driver = gl" > desktopConfig.ini
fi

echo 
echo "Do you want to run Horizon in full screen mode by default?"
echo "Note: You can later on always specifiy the the window vs. fullscreen mode and the resolution via the command line (see --help)."
read -p "Press y for fullscreen, other keys for window: " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]; then
	echo "fullscreen = yes" >> desktopConfig.ini
else
	echo "fullscreen = no" >> desktopConfig.ini
fi

echo 
read -p "Do you want to use mipmaps (recommended) [enter y for yes]: " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]; then
	echo "mipmaps = yes" >> desktopConfig.ini
else
	echo "mipmaps = no" >> desktopConfig.ini
fi

echo "Setup complete."
